/*---------------------------------------------*\
|  Color Nokia LCD Menu Library					|
| This library contains a menu system for the	|
| Nokia Color LCD.  It uses the Nokia Color LCD	|
| Text library (color_lcd_text.h) and Nokia		|
| Color LCD Interface library (color_lcd.h)		|
|												|
| Adam Honse (CalcProgrammer1) 5-10-2011		|
\*---------------------------------------------*/

#ifndef COLOR_LCD_MENU_H
#define COLOR_LCD_MENU_H

#include <util/delay.h>

#include "color_lcd_text.h"
#include "color_lcd.h"

//Print Menu Line
//This function prints a line of text with a background to the display
//char *text:  The character array (string) to print
//textlength:  The number of characters to print (maximum is 21, as it is the width of the screen)
//textcolor:  The text color (in 0x0RGB	format)
//bgcolor:  The background color
//linenumber:  The line number (from 0 [top line] to 12 [bottom line])
void color_lcd_print_menu_line(char * text, char textlength, int textcolor, int bgcolor, char linenumber);

//Print Menu
//This function displays a menu to the user, allows the user to make a selection,
//and returns the menu item that the user selected.  The menu text must be stored
//in an n-by-22 character array with the first line being the menu title and each
//additional line being a menu selection item.  The maximum number of menu items
//is 12, as the LCD can fit 13 lines (including title) and scrolling is not
//implemented in this function.
//
//menu_length:  The number of selectable items in the menu (does not include title)
//starting_position:  Which item to start out selected, must be from 1 to menu_length
//title_color:  The color (in 0x0RGB format) of title text
//title_bgcolor:  The color of title background
//entry_color:  The color of entry text
//entry_bgcolor:  The color of entry background
//highlight_color:  The color of the selected (highlighted) text
//highlight_bgcolor:  The color of the selected (highlighted) item background
char color_lcd_print_menu(char menu_text[][22], char menu_length, char starting_position, int title_color, int title_bgcolor, int entry_color, int entry_bgcolor, int highlight_color, int highlight_bgcolor);

#endif
